<?php
    /*
    * PDFFP Plugin for insert a PDF icon with this link in a article for Joomla! 3.x
    * Version J3_0
    * Creation date: Septembre 2013
    * Author: Fabrice4821 - www.gmapfp.org
    * Author email: webmaster@gmapfp.org
    * License GNU/GPL
    */

defined('_JEXEC') or die;

class PDFFPPluginController extends JControllerLegacy
{
    function display($cachable = false, $urlparams = false)
    {
        $vName = $this->input->get('view', 'grid');
        $vLayout = $this->input->get( 'layout', 'default' );
        $mName = 'grid';

        $document = JFactory::getDocument();
        $vType    = $document->getType();

        // Get/Create the view
        $view = $this->getView($vName, $vType);
		$view->addTemplatePath(JPATH_COMPONENT_ADMINISTRATOR.'/views/'.strtolower($vName).'/tmpl');

        // Get/Create the model
        if ($model = $this->getModel($mName)) {
            // Push the model into the view (as default)
            $view->setModel($model, true);
        }

        // Set the layout
        $view->setLayout($vLayout);

        // Display the view
        $view->display();

		return $this;
    }

	function upload()
	{
		JSession::checkToken('request') or jexit(JText::_('JINVALID_TOKEN'));
		$params = JComponentHelper::getParams('com_media');
		$file       = $this->input->files->get('Filedata', '', 'array');
		
		$return     = $this->input->post->get('return-url', null, 'base64');
		$err		= null;

		// Set FTP credentials, if given
		jimport('joomla.client.helper');
		JClientHelper::setCredentialsFromRequest('ftp');

		if (!array_key_exists('name', $file)) {
			JError::raiseNotice(100, JText::_('COM_PLUGIN_PDFFP_NO_FILE_FOUND'));
			// REDIRECT
			if ($return) {
				$this->redirect(base64_decode($return));
			} else {
				$this->redirect('index.php?option=com_plugin_pdffp&tmpl=component');
			}
			return;
		}

		// Make the filename safe
		jimport('joomla.filesystem.file');
		$file['name']	= JFile::makeSafe($file['name']);

		if (isset($file['name'])) {
			$filepath = JPath::clean(COM_PDF_BASE.'/'.strtolower($file['name']));

			if (JFile::exists($filepath)) {
				JError::raiseNotice(100, JText::_('COM_PLUGIN_PDFFP_ERROR_FILE_EXISTS'));
				// REDIRECT
				if ($return) {
					$this->setRedirect(base64_decode($return));
				}
				return;
			}

			if (
				$_SERVER['CONTENT_LENGTH'] > ($params->get('upload_maxsize', 0) * 1024 * 1024) ||
				$_SERVER['CONTENT_LENGTH'] > (int) (ini_get('upload_max_filesize')) * 1024 * 1024 ||
				$_SERVER['CONTENT_LENGTH'] > (int) (ini_get('post_max_size')) * 1024 * 1024 ||
				(($_SERVER['CONTENT_LENGTH'] > (int) (ini_get('memory_limit')) * 1024 * 1024) && ((int) (ini_get('memory_limit')) != -1))
			)
			{
				JError::raiseWarning(100, JText::_('COM_PLUGIN_PDFFP_ERROR_WARNFILETOOLARGE'));
				if ($return) {
					$this->setRedirect(base64_decode($return));
				}
				return;
			}
			
			// Set FTP credentials, if given
			JClientHelper::setCredentialsFromRequest('ftp');

			if (!JFile::upload($file['tmp_name'], $filepath)) {
				JError::raiseWarning(100, JText::_('COM_PLUGIN_PDFFP_ERROR_BEFORE_SAVE_0'));
				// REDIRECT
				if ($return) {
					$this->setRedirect(base64_decode($return));
				}
				return;
			} else {
				$this->setMessage(JText::_('COM_PLUGIN_PDFFP_UPLOAD_SUCCESSFUL'));
				// REDIRECT
				if ($return) {
					$this->setRedirect(base64_decode($return));
				}
				return;
			}
		} else {
			$this->setRedirect('index.php', 'Invalid Request', 'error');
		}
	}

	function delete()
	{
		$mainframe = JFactory::getApplication(); 

		JSession::checkToken('request') or jexit(JText::_('JINVALID_TOKEN'));

		// Set FTP credentials, if given
		jimport('joomla.client.helper');
		JClientHelper::setCredentialsFromRequest('ftp');
		jimport('joomla.filesystem.file');

		// Get some data from the request
		$tmpl	= $mainframe->input->get( 'tmpl' );
		$files	= $mainframe->input->get( 'rm', array(), 'array' );
		$folder = COM_PDF_BASE;

		// Initialize variables
		$msg = array();
		$ret = true;

		if (count($files)) {
			foreach ($files as $file)
			{
				if ($file !== JFile::makeSafe($file)) {
					JError::raiseWarning(100, JText::sprintf('COM_PLUGIN_PDFFP_ERROR_UNABLE_TO_DELETE_FILE_WARNFILENAME', htmlspecialchars($file, ENT_COMPAT, 'UTF-8')));
					continue;
				}

				$fullPath = JPath::clean($folder.'/'.$file);
				if (is_file($fullPath)) {
					$ret |= !JFile::delete($fullPath);
				}
			}
		}
		if ($tmpl == 'component') {
			// We are inside the iframe
			$mainframe->redirect('index.php?option=com_plugin_pdffp&view=PDFsList&tmpl=component');
		} else {
			$mainframe->redirect('index.php?option=com_plugin_pdffp&view=PDFsList');
		}
	}

	public function ftpValidate()
	{
		// Set FTP credentials, if given
		JClientHelper::setCredentialsFromRequest('ftp');
	}}
