<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.15F
	* Creation date: Septembre 2016
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

class ContactMapViewMap extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	public function display($tpl = null)
	{
		$app = JFactory::getApplication();
		$this->id     = $app->input->getInt('id', $app->input->getInt('contact_id'));
		if (!$this->id) {
			echo '<div class="alert"><h3 class="error message">'.JText::_('COM_CONTACTMAP_ERROR_NOT_ID').'</h3></div>';
			return false;
		}
		
		// Load language for messaging
		$language 	= JFactory::getLanguage();
		$language->load('com_contactmap');

        $lang 	= JFactory::getLanguage(); 
        $tag_lang = (substr($lang->getTag(),0,2)); 
		
		$params 	= JComponentHelper::getParams('com_contactmap');
		$key 	= $params->get('gmapfp_google_key');
		
		$https = "";
		if ((isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && (strtolower($_SERVER['HTTPS']) != 'off')) OR (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && !empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) $https = "s";

		$this->document->setMetaData('viewport', 'initial-scale=1.0, user-scalable=no');
        $this->document->addCustomTag( '<script type="text/javascript" src="http'.$https.'://maps.google.com/maps/api/js?language='.$tag_lang.'&key='.$key.'"></script>'); 

		$this->config		= JComponentHelper::getParams('com_contactmap');
		$this->item			= $this->get('Item');
		$this->state		= $this->get('State');
		$this->marqueurs	= $this->get('Marqueurs');

		parent::display($tpl);
	}
}
