<?php
	/*
	* GMapFP Plugin for Page Builder CK
	* Version J3_2
	* Creation date: Juillet 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/
 
defined('_JEXEC') or die;
jimport('joomla.event.plugin');

class plgPagebuilderckGMapFP_map extends JPlugin {

	private $context = 'PLG_PAGEBUILDERCK_GMAPFP_MAP';

	private $type = 'gmapfp_map';

	/* 
	 * Construct the Menu Item to drag into the interface
	 *
	 * Return Object with item data
	 */
	public function onPagebuilderckAddItemToMenu() {
		// load the language files of the plugin
		$this->loadLanguage();
		// create the menu item
		$menuitem = new stdClass();
		$menuitem->type = $this->type;
		$com_gmapfp_exist = file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php');
		if ($com_gmapfp_exist) {
			$menuitem->title = JText::_($this->context . '_MENUITEM_TITLE');
			$menuitem->description = JText::_($this->context . '_MENUITEM_DESC');
			$menuitem->image = JUri::root(true) . '/plugins/pagebuilderck/gmapfp_map/assets/images/gmapfp.png';
		} else {
			$menuitem->title = JText::_($this->context . '_MENUITEM_TITLE');
			$menuitem->description = JText::_($this->context . '_MENUITEM_DESC_ERROR');
			$menuitem->image = JUri::root(true) . '/plugins/pagebuilderck/gmapfp_map/assets/images/gmapfp.png';
		}

		return $menuitem;
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemContentGMapFP_map() {
		// ckstyle and inner classes are needed to get the styles from the interface
		$input = JFactory::getApplication()->input;
		$id = $input->get('ckid', '', 'string');
		?>
		<div id="<?php echo $id; ?>" class="cktype" data-type="<?php echo $this->type ?>">
			<div class="ckstyle">
			</div>
			<div class="gmapfpck inner">
				<img style="display:block;margin: 0 auto;" src="<?php echo JUri::root(true); ?>/plugins/pagebuilderck/gmapfp_map/assets/images/gmapfp_exemple.jpg" width="100%" height="auto" />
				<div class="gmapfpmarkertitleck"></div>
				<div class="gmapfpmarkercontentck"></div>
			</div>
		</div>
		<?php
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemOptionsGMapFP_map() {
		// load the language files of the plugin
		$this->loadLanguage();
		// load the interface for the options
		$tpl = JPATH_SITE . '/plugins/pagebuilderck/gmapfp_map/layouts/edit_gmapfp_map.php';
		return $tpl;
	}

	/* 
	 * Display the html code for the item to be used into the frontend page
	 * @param string the item object from simple_html_dom
	 * 
	 * Return String the html code
	 */
	public function onPagebuilderckRenderItemGMapFP_map($item) {
		// load the helper to help us to use the parameters
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/pagebuilderckfront.php';

		// ckstyle and inner classes are needed to get the styles from the interface
		$ckstyle = $item->find('.ckstyle');
		$styles = count($ckstyle) ? $ckstyle[0]->innertext : '';

		$mapattrs = $item->find('.tab_map'); // this is the tab id in the interface which contains the map options
		$params = PagebuilderckFrontHelper::createParamsFromElement($mapattrs);
		$html = '';
		$id = '';
		$catid = '';
		if ($params->get('gmapfpcatid')) $catid = explode(',', $params->get('gmapfpcatid'));
		if ($params->get('gmapfpplaceid')) $id = explode(',', $params->get('gmapfpplaceid'));
		$kml = $params->get('gmapfpkml', '');
		$largeur = $params->get('gmapfpwidth', '');
		$hauteur = (int)$params->get('gmapfpheight', '');
		$zoom = $params->get('gmapfpzoom', '');
		$itin = $params->get('gmapfpitin', '');
		
		$language 	= JFactory::getLanguage();
		$language->load('com_gmapfp');
			
		$com_gmapfp_exist = file_exists(JPATH_SITE.'/components/com_gmapfp/models/gmapfp.php');
		if ($com_gmapfp_exist) {
			require_once JPATH_SITE.'/components/com_gmapfp/models/gmapfp.php';
			if (class_exists('GMapFPModelGMapFP'))
				$model = new GMapFPModelGMapFP();
			elseif (class_exists('GMapFPsModelGMapFP'))
				$model = new GMapFPsModelGMapFP();
			else
				$model = new GMapFPsModelGMapFPs();

			$random = rand(1, 999);
			$bar_PSM = "";
			$bar_z_nav = "";
			$Ech = "";
			$click_over = "";
			$MZoom = "";
			$ZZoom = "";
			$map_phy = "";
			$map_nor = "";
			$map_sat = "";
			$map_hyb = "";
			$map_choix = "";
			$map_earth = "";
			$map_centre_lng = "";
			$map_centre_lat = "";
			$More = "";
			$map_centre_id = "";
			$where = "";
			$plus_detail = "";

			$map = $model->getViewPlugin($id, $item->id.'_'.$random, $hauteur, $largeur, $zoom, $itin, $bar_PSM, $bar_z_nav, $Ech, $click_over, $MZoom, $ZZoom, $map_phy, $map_nor, $map_sat, $map_hyb, $map_choix, $kml, $map_earth, $map_centre_lng, $map_centre_lat, $catid, $More,$map_centre_id,$where,$plus_detail);
			$map = '<div id="gmapfp_plugin_'.$item->id.'_" class="gmapfp gmapfp_plugin">'.$map.'</div>';

			$html = '
			<div class="ckstyle">
				'. $styles . '
			</div>
			<div class="gmapfpck inner">
				'.$map.'
			</div>';
		}
		return $html;
	}
}