<?php
	/*
	* GMapFP Ajax Plugin for Page Builder CK
	* Version J3_3
	* Creation date: Octobre 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/
 
defined('_JEXEC') or die;
jimport('joomla.event.plugin');

class plgAjaxGetgmapfpdatas extends JPlugin {
	function onAjaxGetgmapfpdatas() {
		$app	= JFactory::getApplication();
		$input  = $app->input;
		$gmapfp_pro =  file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/champs.php');
		
		$data = $input->get('data');
		
		$function = $input->get('cmd');
		
		if ($function == "update_places") {
			$list_lieux = array();

			$com_gmapfp_exist = file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php');
			if ($com_gmapfp_exist) {
				require_once JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php';
				if (class_exists('GMapFPModelGMapFP'))
					$model = new GMapFPModelGMapFP();
				elseif (class_exists('GMapFPsModelGMapFP'))
					$model = new GMapFPsModelGMapFP();
				elseif (class_exists('GMapFPModelGMapFPs'))
					$model = new GMapFPModelGMapFPs();
				else
					$model = new GMapFPsModelGMapFPs();
				// désactive la gestion de la taille maximum de la liste
				$model->setState('limit', 0);
				$model->setState('limitstart', 0);

				// récupère la list des places
				$lieux = $model->getData();
				
				$filter = $input->get('filter');

				if (count($lieux)>0)
				foreach ($lieux as $lieu){
					$catids = explode(',', $lieu->catid);
					if ($lieu->published == 1 and (in_array($data, $catids) or $data == 0) and ($filter=="" or stripos($lieu->nom, $filter)!==false)) {
						$tmp = array();
						$tmp['value'] = $lieu->id;
						$tmp['text'] = html_entity_decode($lieu->nom);
						$list_lieux[$lieu->nom.' '.rand()] = $tmp;
					}
				}
				unset($lieux, $lieu, $tmp);
				ksort($list_lieux, SORT_NATURAL);
			}
			
			return $list_lieux;
		}

		if ($function == "get_place_info") {
			$db    		= JFactory::getDbo();
			$now    	= JFactory::getDate();
			$nullDate 	= $db->getNullDate();
			
			$ids = implode(' OR id = ', $data);
			$ids = ' (id = '.$ids.')';
			
			if($gmapfp_pro)
				$where = $db->quoteName('published') . ' = "1" and ' . '( publish_up = \'\' OR publish_up = '.$db->Quote($nullDate).' OR publish_up <= '.$db->Quote($now).' )' . 
					'and ( publish_down = \'\' OR publish_down = '.$db->Quote($nullDate).' OR publish_down >= '.$db->Quote($now).' ) and '.$ids;
			else
				$where = $db->quoteName('published') . ' = "1"  and '.$ids;
			
			$query = $db->getQuery(true);
			$query
				->select($db->quoteName(array('nom', 'img', 'id')))
				->from($db->quoteName('#__gmapfp'))
				->where($where);
			$db->setQuery( $query );
			return $db->loadObjectList();
		}
		
		if ($function == "get_place_cat_info") {
			$db    		= JFactory::getDbo();
			$now    	= JFactory::getDate();
			$nullDate 	= $db->getNullDate();
			$wheres		= array();

			foreach ($data as $cat) {
				$wheres[] = '(catid LIKE "'.$cat.',%"'.' OR catid LIKE "%,'.$cat.',%"'.' OR catid LIKE "%,'.$cat.'"'.' OR catid = "'.$cat.'")';
			}
			$ids = implode( '  OR ', $wheres );

			if($gmapfp_pro)
				$where = $db->quoteName('published') . ' = "1" and ' . '( publish_up = \'\' OR publish_up = '.$db->Quote($nullDate).' OR publish_up <= '.$db->Quote($now).' )' . 
					'and ( publish_down = \'\' OR publish_down = '.$db->Quote($nullDate).' OR publish_down >= '.$db->Quote($now).' ) and '.$ids;
			else
				$where = $db->quoteName('published') . ' = "1"  and '.$ids;
				
			$query = $db->getQuery(true);
			$query
				->select($db->quoteName(array('nom', 'img', 'id')))
				->from($db->quoteName('#__gmapfp'))
				->where($where);
			$db->setQuery( $query );
			return $db->loadObjectList();
		}
		
		if ($function == "get_place_cat") {
			return JHtml::_('category.options', 'com_gmapfp');
		}
		
		return false;
    }	
}

?>