--
-- Insert data into table `#__content_types` for UCM functions
--
INSERT INTO `#__content_types` (`type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
('GMapFP', 'com_gmapfp.item', '{"special":{"dbtable":"#__gmapfp","key":"id","type":"Item","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"img", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "asset_id":"null"}, "special":{"adresse":"adresse","adresse2":"adresse2","ville":"ville","departement":"departement","codepostal":"codepostal","pays":"pays","tel":"tel","email":"email","web":"web","fulltext":"fulltext","horaires_prix":"horaires_prix","article_id":"article_id","icon":"icon","icon_label":"icon_label","affichage":"affichage","marqueur":"marqueur","glat":"glat","glng":"glng","gzoom":"gzoom"}}', 'GMapFPHelperRoute::getItemRoute', '{"formFile":"administrator\\/components\\/com_gmapfp\\/models\\/forms\\/item.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","img"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
('GMapFP Category', 'com_gmapfp.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'LivresFPHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

CREATE TABLE IF NOT EXISTS `#__gmapfp` (
    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
    `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
    `title` varchar(255) NOT NULL,
    `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
    `adresse` varchar(200) DEFAULT NULL,
    `adresse2` varchar(200) DEFAULT NULL,
    `ville` varchar(200) DEFAULT NULL,
    `departement` varchar(200) DEFAULT NULL,
    `codepostal` varchar(80) DEFAULT NULL,
    `pays` varchar(200) DEFAULT NULL,
    `tel` varchar(30) DEFAULT NULL,
    `email` varchar(100) DEFAULT NULL,
    `web` varchar(200) DEFAULT NULL,
    `img` text DEFAULT NULL,
    `introtext` mediumtext DEFAULT NULL,
    `fulltext` mediumtext DEFAULT NULL,
    `horaires_prix` mediumtext DEFAULT NULL,
    `link` varchar(200) DEFAULT NULL,
    `article_id` int(100) DEFAULT '0',
    `icon` varchar(100) DEFAULT NULL,
    `icon_label` varchar(100) DEFAULT NULL,
    `affichage` smallint(1) DEFAULT '0',
    `marqueur` varchar(200) DEFAULT NULL,
    `glng` varchar(12) DEFAULT NULL,
    `glat` varchar(12) DEFAULT NULL,
    `gzoom` varchar(2) DEFAULT NULL,
    `catid` int(10) unsigned NOT NULL DEFAULT '0',
	`access` int(10) unsigned NOT NULL DEFAULT '0',
	`state` tinyint(3) NOT NULL DEFAULT '0',
    `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
	`checked_out_time` datetime,
	`language` varchar(7) NOT NULL,
	`created` datetime NOT NULL,
	`created_by` int(10) unsigned NOT NULL DEFAULT '0',
	`created_by_alias` varchar(255) NOT NULL DEFAULT '',
	`modified` datetime NOT NULL,
	`modified_by` int(10) unsigned NOT NULL DEFAULT '0',
    `metadesc` text DEFAULT NULL,
    `metakey` text DEFAULT NULL,
	`metadata` text DEFAULT NULL,
    `ordering` int(11) NOT NULL DEFAULT '0',
	`featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if item is featured.',
	`publish_up` datetime,
	`publish_down` datetime,
	`attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
	`version` int(10) unsigned NOT NULL DEFAULT '1',
	`hits` int(10) unsigned NOT NULL DEFAULT '0',
    `note` varchar(255) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_checkout` (`checked_out`),
	KEY `idx_catid` (`catid`),
	KEY `idx_createdby` (`created_by`),
	KEY `idx_featured_catid` (`featured`,`catid`),
	KEY `idx_language` (`language`),
	KEY `idx_state` (`state`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__gmapfp_personnalisation` (
    `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
    `nom` varchar(200) NOT NULL,
    `intro_carte` mediumtext DEFAULT NULL,
    `conclusion_carte` mediumtext DEFAULT NULL,
    `intro_detail` mediumtext DEFAULT NULL,
    `conclusion_detail` mediumtext DEFAULT NULL,
	`state` tinyint(3) NOT NULL DEFAULT 0,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__gmapfp_marqueurs` (
  `id` int(11) NOT NULL auto_increment,
  `nom` text NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url` text NOT NULL,
  `marker_width` int(4),
  `marker_height` int(4),
  `centre_x` int(4),
  `centre_y` int(4),
  `url_shadow` text DEFAULT NULL,
  `shadow_width` int(4),
  `shadow_height` int(4),
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime,
  `optimized` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__gmapfp_marqueurs` (`nom`, `alias`, `url`, `marker_width`, `marker_height`, `centre_x`, `centre_y`, `state`, `ordering`) VALUES
('Accueil', 'accueil', 'images/gmapfp/marqueurs/accueil.png', '26', '34', '12', '34', '1', '0'),
('Cadeau', 'cadeau', 'images/gmapfp/marqueurs/cadeau.png', '26', '34', '12', '34', '1', '1'),
('Cadenas', 'cadenas', 'images/gmapfp/marqueurs/cadenas.png', '26', '34', '12', '34', '1', '2'),
('Cloud', 'cloud', 'images/gmapfp/marqueurs/cloud.png', '26', '34', '12', '34', '1', '3'),
('Coeur', 'coeur', 'images/gmapfp/marqueurs/coeur.png', '26', '34', '12', '34', '1', '4'),
('Couvert', 'couvert', 'images/gmapfp/marqueurs/couvert.png', '26', '34', '12', '34', '1', '5'),
('Etoile', 'etoile', 'images/gmapfp/marqueurs/etoile.png', '26', '34', '12', '34', '1', '6'),
('Immeuble', 'immeuble', 'images/gmapfp/marqueurs/immeuble.png', '26', '34', '12', '34', '1', '7'),
('Imprimante', 'imprimante', 'images/gmapfp/marqueurs/imprimante.png', '26', '34', '12', '34', '1', '8'),
('Loupe', 'loupe', 'images/gmapfp/marqueurs/loupe.png', '26', '34', '12', '34', '1', '9'),
('Neige', 'neige', 'images/gmapfp/marqueurs/neige.png', '26', '34', '12', '34', '1', '10'),
('Orage', 'orage', 'images/gmapfp/marqueurs/orage.png', '26', '34', '12', '34', '1', '11'),
('Panier', 'panier', 'images/gmapfp/marqueurs/panier.png', '26', '34', '12', '34', '1', '12'),
('Personne', 'personne', 'images/gmapfp/marqueurs/personne.png', '26', '34', '12', '34', '1', '13'),
('Pluie', 'pluie', 'images/gmapfp/marqueurs/pluie.png', '26', '34', '12', '34', '1', '14'),
('Sac', 'sac', 'images/gmapfp/marqueurs/sac.png', '26', '34', '12', '34', '1', '15'),
('Soleil', 'soleil', 'images/gmapfp/marqueurs/soleil.png', '26', '34', '12', '34', '1', '16'),
('Vent', 'vent', 'images/gmapfp/marqueurs/vent.png', '26', '34', '12', '34', '1', '16'),
('Bleu', 'bleu', 'images/gmapfp/marqueurs/blue-dot.png', '32', '32', '14', '34', '1', '16'),
('Vert', 'vert', 'images/gmapfp/marqueurs/green-dot.png', '32', '32', '14', '34', '1', '16'),
('Orange', 'orange', 'images/gmapfp/marqueurs/orange-dot.png', '32', '32', '14', '34', '1', '16'),
('Rose', 'rose', 'images/gmapfp/marqueurs/pink-dot.png', '32', '32', '14', '34', '1', '16'),
('Violet', 'violet', 'images/gmapfp/marqueurs/purple-dot.png', '32', '32', '14', '34', '1', '16'),
('Jaune', 'jaune', 'images/gmapfp/marqueurs/yellow-dot.png', '32', '32', '14', '34', '1', '16');
