<?php
	/*
	* GMapFP Component Google Map for Joomla! 4.0.x
	* Version J4_0_0F
	* Creation date: Octobre 2020
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$js = '
Joomla = window.Joomla || {};

(Joomla => {
	Joomla.submitbutton = task => {
		Joomla.submitform(task, document.getElementById(\'item-form\'));
		if (task == "config.cancel" || task == "config.save") setTimeout(function(){window.close();}, 200);
	};
})(Joomla);
';

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
	->useScript('form.validate')
	->useScript('webcomponent.toolbar-button')
	->useStyle('bootstrap.css')
	->useStyle('fontawesome')
	->addInlineScript($js)
	;

$template = Factory::getApplication()->getTemplate();
HTMLHelper::_('stylesheet', "media/templates/administrator/$template/css/template.css");

$style = ':root {
		--hue: 214;
		--template-bg-light: #f0f4fb;
		--template-text-dark: #495057;
		--template-text-light: #ffffff;
		--template-link-color: #2a69b8;
		--template-special-color: #001b4c;
	}';
$this->document->addStyleDeclaration($style);

$app = Factory::getApplication();
$input = $app->input;
$plug_type = $input->get( 'plug_type' );
$plug_name = $input->get( 'plug_name' );

?>		
			
<form action="<?php echo Route::_('index.php?option=com_gmapfp&view=config&layout=edit&tmpl=component&plug_type='.$plug_type.'&plug_name='.$plug_name); ?>" method="post" name="adminForm" id="item-form" class="form-validate">
	<div id="subhead" class="subhead mb-3 load-fadein bg-white shadow-sm" >
		<div id="container-collapse" class="container-collapse"></div>
			<div class="row">
				<div class="col-md-12">
					<nav aria-label="Toolbar" tabindex="-1" id="ui-skip-84">
						<div class="btn-toolbar d-flex" role="toolbar" id="toolbar">

							<?php if ($this->canDo->get('core.admin') || $canDo->get('core.options')) : ?>
								<joomla-toolbar-button id="toolbar-apply" task="config.apply" form-validation="">
									<button class="button-apply btn btn-success" type="button">
									<span class="icon-apply" aria-hidden="true"></span>
									<?php echo Text::_('JTOOLBAR_APPLY'); ?></button>
								</joomla-toolbar-button>
							
								<joomla-toolbar-button id="toolbar-save" task="config.save" form-validation>
									<button class="button-save  btn btn-success" type="button">
									<span class="icon-save" aria-hidden="true"></span>
									<?php echo Text::_('JTOOLBAR_SAVE'); ?></button>
								</joomla-toolbar-button>
							<?php endif; ?>

							<joomla-toolbar-button id="toolbar-cancel" task="config.cancel">
								<button class="button-cancel  btn btn-danger" type="button">
								<span class="icon-cancel" aria-hidden="true"></span>
								<?php echo Text::_('JTOOLBAR_CLOSE'); ?></button>
							</joomla-toolbar-button>

					</div>
				</nav>
			</div>
		</div>
	</div>
	<div>
		<div class="row">
			<div class="col-md-12 form-vertical form-no-margin">
				<?php echo $this->form->renderFieldset('basic'); ?>
			</div>
		</div>
	</div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="plug_type" value="<?php echo $plug_type; ?>" />
	<input type="hidden" name="plug_name" value="<?php echo $plug_name; ?>" />
	<?php echo HTMLHelper::_( 'form.token' ); ?>
</form>
<div class="copyright" align="center">
	<br />
	<?php echo Text::_( 'COM_GMAPFP_COPYRIGHT' );?>
</div>
