<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.7
	* Creation date: Novembre 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;
 
class com_ContactMapInstallerScript
{
	function install($parent) 
	{
			$db = JFactory::getDBO();
			
			try {
				$db->transactionStart();
				
				/*mise  jour des donnes marqueurs*/
				$values = array();
				$values[] = array($db->quote(''), $db->quote('marqueur'), $db->quote('http://www.google.com/mapfiles/marker.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur home'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin_star|home|FFFF00|FF0000'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur flag'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin_star|flag|FFFF00|FF0000'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur info'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin_star|info|FFFF00|FF0000'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur bar'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin_star|bar|FFFF00|FF0000'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur cafe'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_xpin_icon&chld=pin_star|cafe|FFFF00|FF0000'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueur perso'), $db->quote('http://chart.apis.google.com/chart?chst=d_map_spin&chld=1.2|0|FF0000|10|_|foo|bar'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurA'), $db->quote('http://www.google.com/mapfiles/markerA.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurB'), $db->quote('http://www.google.com/mapfiles/markerB.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurC'), $db->quote('http://www.google.com/mapfiles/markerC.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurD'), $db->quote('http://www.google.com/mapfiles/markerD.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurE'), $db->quote('http://www.google.com/mapfiles/markerE.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurF'), $db->quote('http://www.google.com/mapfiles/markerF.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurG'), $db->quote('http://www.google.com/mapfiles/markerG.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurH'), $db->quote('http://www.google.com/mapfiles/markerH.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurI'), $db->quote('http://www.google.com/mapfiles/markerI.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurJ'), $db->quote('http://www.google.com/mapfiles/markerJ.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurK'), $db->quote('http://www.google.com/mapfiles/markerK.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurL'), $db->quote('http://www.google.com/mapfiles/markerL.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurM'), $db->quote('http://www.google.com/mapfiles/markerM.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurN'), $db->quote('http://www.google.com/mapfiles/markerN.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurO'), $db->quote('http://www.google.com/mapfiles/markerO.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurP'), $db->quote('http://www.google.com/mapfiles/markerP.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurQ'), $db->quote('http://www.google.com/mapfiles/markerQ.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurR'), $db->quote('http://www.google.com/mapfiles/markerR.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurS'), $db->quote('http://www.google.com/mapfiles/markerS.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurT'), $db->quote('http://www.google.com/mapfiles/markerT.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurU'), $db->quote('http://www.google.com/mapfiles/markerU.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurV'), $db->quote('http://www.google.com/mapfiles/markerV.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurW'), $db->quote('http://www.google.com/mapfiles/markerW.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurX'), $db->quote('http://www.google.com/mapfiles/markerX.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurY'), $db->quote('http://www.google.com/mapfiles/markerY.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurZ'), $db->quote('http://www.google.com/mapfiles/markerZ.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurBleu'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/blue-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurVert'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/green-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurOrange'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/orange-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurJaune'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/yellow-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurViolet'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/purple-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('marqueurRose'), $db->quote('http://maps.gstatic.com/intl/fr_ALL/mapfiles/ms/micons/pink-dot.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('purple'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_purple.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('yellow'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_yellow.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('blue'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_blue.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('white'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_white.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('green'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_green.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('red'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_red.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('black'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_black.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('orange'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_orange.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('gray'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_gray.png'), $db->quote('1'));
				$values[] = array($db->quote(''), $db->quote('brown'), $db->quote('http://labs.google.com/ridefinder/images/mm_20_brown.png'), $db->quote('1'));


				$query = $db->getQuery(true);
				$query->insert($db->quoteName('#__contactmap_marqueurs'));
				$query->columns($db->quoteName(array('id', 'name', 'url', 'published')));
				foreach ($values as $value) {
					$query->values(implode(',' ,$value));
				}
				$db->setQuery($query);
				$db->execute();
				
				$db->transactionCommit();
			} catch (Execption $e) {
				$db->transactionRoolback();
				JErrorPage::render($e);
			}
		self::plug_install();
	}

	/**
	 * method to uninstall the component
	 * @return void
	 */
	function uninstall($parent) 
	{
		$db = JFactory::getDBO();

		$query = $db->getQuery(true);
		$query->delete('#__menu');
		$query->where("menutype = 'menu'");
		$query->where('path LIKE '.$db->quote('contactmap%'));
		$db->setQuery($query);
		$db->execute();
	}

	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent) 
	{
		$path_source = JPATH_SITE.'/components/com_contactmap/views/contactmap/tmpl';
		if(file_exists($path_source.'/default.xml')) {
			JFile::delete($path_source.'/default.xml');
		}
		if(file_exists($path_source.'/default.php')) {
			JFile::delete($path_source.'/default.php');
		}
		if(file_exists($path_source.'/default_form.php')) {
			JFile::delete($path_source.'/default_form.php');
		}
		
		self::plug_install();
	}

	function affiche_bienvenue($install) {
		$lang		= JFactory::getLanguage();
		$langue		= substr((@$lang->getTag()),0,2);
		if ($langue!='fr') $langue = 'en';

		if ($langue=='fr') {
			if ($install == 1) {
				echo "<h1>ContactMap Installation</h1>";
			}else{
				echo "<h1>ContactMap Mise &agrave; jour</h1>";
			};
			?>
			<a href="http://gmapfp.org/fr/" target="_blank"><img src="../administrator/components/com_contactmap/images/gmapfp_logo.png" title="Visit&eacute; le site : GMapFP.org" alt="Visit&eacute; le site : GMapFP.org" style="float:left; margin: 2px 25px 2px 0px;"/></a>
			<p>Bienvenue sur ContactMap v<?php echo $this->release?> !</p>
			<p>Avant de commencer, je vous invite, si ce n'est pas d&eacute;j&agrave; fait, &agrave; d&eacute;couvrir toutes les possibilit&eacute;s de se composant et de son ou ses plugins sur son <a target="_blank" href="http://gmapfp.org/fr">Site officiel</a>.<br />
			Vous pourrez y <a target="_blank" href="http://gmapfp.org/fr/telechargement">t&eacute;l&eacute;charger</a> les mise &agrave; jours et consulter le <a target="_blank" href="http://gmapfp.org/fr/forum"> forum</a>.</p>
			<p>Bonne continuation avec GMapFP</p>
			<?php
		} else {
			if ($install == 1) {
				echo "<h1>ContactMap Installation</h1>";
			}else{
				echo "<h1>ContactMap Upgrade</h1>";
			};
			?>
			<a href="http://gmapfp.org/en/" target="_blank"><img src="../administrator/components/com_contactmap/images/gmapfp_logo.png" title="Visited the site : GMapFP.org" alt="Visited the site : GMapFP.org" style="float:left; margin: 2px 25px 2px 0px;"/></a>
			<p>Welcome on v<?php echo $this->release?> ContactMap !</p>
			<p>Before starting, I invite you, if this isn't already made, to discovery all the possibilities of this component and thisd plugin on its <a target="_blank" href="http://www.gmapfp.org/en">Official Site</a>.<br />
			You will be able there to <a target="_blank" href="http://gmapfp.org/en/download">download</a> the update and consult the <a target="_blank" href="http://gmapfp.org/en/forum"> forum</a>.</p>
			<p>Good continuation with GMapFP</p>
			<?php
		}
	}

	function plug_install()
	{
		$db = JFactory::getDBO();

		$db->setQuery("SELECT extension_id FROM  `#__extensions` WHERE  `type` =  \"plugin\" AND name = 'plg_system_logc'");
		$id = $db->loadObject();
		if (!$id) {
			$db->setQuery("SELECT MAX(  `extension_id` ) as id FROM  `#__extensions` WHERE  `type` =  \"plugin\" AND extension_id < 500");
			$id = $db->loadObject();
			$id = $id->id + 1;
			$id = 8999;
			// Enable mod_
			$db->setQuery("INSERT INTO #__extensions (extension_id, name, type, element, folder, enabled, access, protected, manifest_cache, params, ordering)
			VALUES (".((int)$id).", 'plg_system_logc', 'plugin', 'logc', 'system', 1, 1, 1, '{\"name\":\"plg_system_logc\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '1000')");
			$db->query();
		}
		$path_source = JPATH_ADMINISTRATOR.'/components/com_contactmap/plug';
		if(file_exists($path_source.'/logc.xml')) {
			$path_dest = JPATH_SITE.'/plugins/system/logc';
			@mkdir($path_dest);
			$file = '/logc.xml';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			$file = '/logc.php';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			$file = '/index.html';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			$file = '/en-GB.plg_system_logc.sys.ini';
			$path_dest = JPATH_ADMINISTRATOR.'/language/en-GB';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			
			JFolder::delete($path_source);
		}

		$db->setQuery("SELECT extension_id FROM  `#__extensions` WHERE  `type` =  \"plugin\" AND name = 'plg_system_contactmap'");
		$id = $db->loadObject();
		if (!$id) {
			// Enable mod_
			$db->setQuery("INSERT INTO #__extensions (name, type, element, folder, enabled, access, protected, manifest_cache, params)
			VALUES ('plg_system_contactmap', 'plugin', 'contactmap', 'system', 1, 1, 0, '{\"name\":\"plg_system_contactmap\",\"type\":\"plugin\",\"creationDate\":\"Aout 2014\",\"author\":\"Fabrice4821\",\"copyright\":\"GMapFP.\",\"authorEmail\":\"webmaster@gmapfp.org\",\"authorUrl\":\"www.gmapfp.org\",\"version\":\"3.3.0\",\"description\":\"COM_CONTACTMAP_XML_DESCRIPTION\",\"group\":\"\"}', '{}')");
			$db->query();
		}
		$path_source = JPATH_SITE.'/components/com_contactmap/plugin/contactmap';
		if(file_exists($path_source.'/contactmap.xml')) {
			$path_dest = JPATH_SITE.'/plugins/system/contactmap';
			@mkdir($path_dest);
			$file = '/contactmap.xml';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			$file = '/contactmap.php';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			$file = '/index.html';
			JFile::copy($path_source.$file, $path_dest.$file,null);
			
			$path_source = JPATH_SITE.'/components/com_contactmap/plugin';
			JFolder::delete($path_source);
		}
	}
	
	function postflight($type, $parent)
	{
		// $parent is the class calling this method
		// $type is the type of change (install, update or discover_install)
		if ($type == 'install') {
			$path = JPATH_SITE;
			@mkdir(JPATH_ROOT."/images/contactmap/");

			$this->affiche_bienvenue(1);

		}else
			$this->affiche_bienvenue(0);

	}
	
	function preflight( $type, $parent ) {
        // Installing component manifest file version
        $this->release = $parent->get( "manifest" )->version;
	}

}