<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.20F
	* Creation date: Septembre 2018
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die();

class JFormFieldContactMapMap extends JFormField
{
	public $type = 'ContactMapMap';

	protected function getInput()
	{
        $lang = JFactory::getLanguage(); 
        $tag_lang=(substr($lang->getTag(),0,2)); 

		$params 	= JComponentHelper::getParams('com_contactmap');
		$key 	= $params->get('gmapfp_google_key');
		
return '
		<meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
		<script src="//maps.google.com/maps/api/js?language='.$tag_lang.'&key='.$key.'" type="text/javascript"></script>
		<script src="//www.google.com/jsapi" type="text/javascript"></script><noscript>JavaScript must be enabled in order for you to use Google Maps. However, it seems JavaScript is either disabled or not supported by your browser. To view Google Maps, enable JavaScript by changing your browser options, and then try again.</noscript>
		<fieldset style="height: 300px; width: 650px; overflow:hidden; " class="radio">
			<div id="map_param_contactmap" style="height: 300px; width: 100%; overflow:hidden;"></div>
		</fieldset>

		<script language="javascript" type="text/javascript">//<![CDATA[
			var map;
			var marker1;
		
			function init() {
				var lat, lng, zoom_carte;
				lat = document.getElementById("jform_contactmap_centre_lat").value;
				lng = document.getElementById("jform_contactmap_centre_lng").value;
				zoom_carte = parseInt(document.getElementById("jform_contactmap_zoom").value);
		
				var latlng = new google.maps.LatLng(lat, lng);
				var myOptions = {
				  zoom: zoom_carte,
				  center: latlng,
				  mapTypeId: google.maps.MapTypeId.ROADMAP
				};
		
				map = new google.maps.Map(document.getElementById("map_param_contactmap"), myOptions);
		
			  google.maps.event.addListener(map, "bounds_changed", function() {
				   jQuery("#jform_contactmap_zoom").val(map.getZoom());
			  });
			  // Create a draggable marker which will later on be binded to a
			  marker1 = new google.maps.Marker({
				  map: map,
				  position: new google.maps.LatLng(lat, lng),
				  draggable: true,
				  title: "Drag me!"
			  });
			  google.maps.event.addListener(marker1, "drag", function() {
				document.getElementById("jform_contactmap_centre_lat").value = marker1.getPosition().lat();
				document.getElementById("jform_contactmap_centre_lng").value = marker1.getPosition().lng();
			  });
			}
		
			// Register an event listener to fire when the page finishes loading.
			//google.maps.event.addDomListener(window, "load", init);
			google.maps.event.addDomListener(window,  \'load\', initialize);

			var tstGMapFP = document.getElementById("map");
			var tstIntGMapFP;
			
			function CheckGMapFP() {
				if (tstGMapFP) {
					if (tstGMapFP.offsetWidth != tstGMapFP.getAttribute("oldValue")) {
						tstGMapFP.setAttribute("oldValue",tstGMapFP.offsetWidth);
						init();
					}
				}
			}
			
			function initialize() {
			   tstGMapFP.setAttribute("oldValue",0);
			   tstIntGMapFP = setInterval("CheckGMapFP()",500);
			}
		 
		//]]></script>
';

	}
}

?>