<?php
	/*
	* ContactMap Component Google Map for Joomla! 3.x
	* Version J3.0
	* Creation date: Aot 2014
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die;

JHtml::_('bootstrap.tooltip');
JHtml::_('formbehavior.chosen', 'select');

$doc		= JFactory::getDocument();

$default_marqueur = 1;

$_lat = $this->config->get('contactmap_centre_lat', '47.9293');
$_lng = $this->config->get('contactmap_centre_lng', '2.1393');
$_zoom = $this->config->get('contactmap_zoom', '5');

if ($this->item->lat and $this->item->lng)
	$show_adresse = '';
else
	$show_adresse = 'if (jQuery(\'#localisation\').val().trim() != \',\') showAddress();';

$srcipt = '
	<script type="text/javascript">
		function init_GMapFP() {
			geocoder = new google.maps.Geocoder();
			
			if(document.adminForm.glat.value!=0) lat = document.adminForm.glat.value;
			else lat = '.$_lat.';
			if(document.adminForm.glng.value!=0) lng = document.adminForm.glng.value;
			else lng = '.$_lng.';
			if(document.adminForm.gzoom.value!=0) zoom_carte = parseInt(document.adminForm.gzoom.value);
			else zoom_carte = '.$_zoom.';

			var latlng = new google.maps.LatLng(lat, lng);
			var myOptions = {
			  zoom: zoom_carte,
			  center: latlng,
			  //mapTypeId: '.$this->config->get('com_contactmap_type_admin', 'roadmap').'
			  mapTypeId: google.maps.MapTypeId.ROADMAP
			};

			map = new google.maps.Map(document.getElementById("map"), myOptions);

		  google.maps.event.addListener(map, "bounds_changed", function() {
			   document.adminForm.gzoom.value = map.getZoom();
		  });

		  // Create a draggable marker which will later on be binded to a
		  marker1 = new google.maps.Marker({
			  map: map,
			  position: new google.maps.LatLng(lat, lng),
			  draggable: true,
			  title: "'.JText::_('COM_CONTACTMAP_DRAG_ME').'"
		  });
		  google.maps.event.addListener(marker1, "drag", function() {
			document.adminForm.glat.value = marker1.getPosition().lat();
			document.adminForm.glng.value = marker1.getPosition().lng();
		  });
		  '.$show_adresse.'
		}

		var tstIntGMapFP;
		
		function CheckGMapFP() {
			if (document.getElementById("map")) {
				if (document.getElementById("map").offsetWidth != document.getElementById("map").getAttribute("oldValue")) {
					document.getElementById("map").setAttribute("oldValue",document.getElementById("map").offsetWidth);
					init_GMapFP();
				}
			}
		}
		
		function pre_init_GMapFP() {
		   document.getElementById("map").setAttribute("oldValue",0);
		   tstIntGMapFP = setInterval("CheckGMapFP()",500);
		}

    function showAddress() {
		var address = document.adminForm.localisation.value;
		if (geocoder) {
			geocoder.geocode( { \'address\' : address}, function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
				  map.setCenter(results[0].geometry.location);
				  marker1.setPosition(results[0].geometry.location); 
					document.adminForm.glat.value = results[0].geometry.location.lat();
					document.adminForm.glng.value = results[0].geometry.location.lng();
				} else {
				  alert(address + "'.JText::_('COM_CONTACTMAP_ADRESSE_NOT_FUND').' not found for the following reason: " + status);
				}
			})
		}
    }

    function getCoordinate() {
        if(document.adminForm.glat.value!=0) lat = document.adminForm.glat.value;
        else lat = '.$_lat.';
        if(document.adminForm.glng.value!=0) lng = document.adminForm.glng.value;
        else lng = '.$_lng.';
        if(document.adminForm.gzoom.value!=0) zoom_carte = parseInt(document.adminForm.gzoom.value);
        else zoom_carte = '.$_zoom.';

		var latlng = new google.maps.LatLng(lat, lng);
		map.setZoom(zoom_carte);
		map.setCenter(latlng);
		marker1.setPosition(latlng); 
    }
	
	function IsReal(id){
		MonNombre=document.getElementById(id).value;
		if(isNaN(MonNombre))
		{
			alert("\"" + MonNombre + "\" '.JText::_( 'COM_CONTACTMAP_PAS_NOMBRE' ).'");
			return false;
		}	
		return true;
	}

</script>		

	<script type="text/javascript">
		var lat, lng, zoom_carte;

		jQuery(document).ready(function() {
			pre_init_GMapFP();
			var add = parent.jQuery(\'#jform_address\').val();
			var ville = parent.jQuery(\'#jform_suburb\').val();
			var region = parent.jQuery(\'#jform_state\').val();
			var cp = parent.jQuery(\'#jform_postcode\').val();
			var pays = parent.jQuery(\'#jform_country\').val();
			var adresse = add + ", " + cp + " " + ville + " " + region + " " + pays;
			jQuery(\'#localisation\').val(adresse);
		});
	</script>		
	
';
$doc->addCustomTag($srcipt);

?>

<form action="<?php echo JRoute::_('index.php?option=com_contactmap&view=map&layout=modal&tmpl=component&id=').$this->id;?>" method="post" name="adminForm" id="adminForm">
	<p><button onclick="submit('map.apply')" style="font-size: 1.4em;" class="btn btn-small btn-success">
		<span class="icon-apply icon-white"></span>
		<?php echo JText::_('COM_CONTACTMAP_SAVE_INFORMATION'); ?>
	</button></p>
	<table class="admintable">
		<tr>
			<td width="110" class="key">
				<label for="localisation">       
					<?php echo JText::_('COM_CONTACTMAP_ADRESSE'); ?>
				</label>
			</td>
			<td valign="top">
				<input type="text" style="width:70%" id="localisation" name="localisation" value="" />
				<div class="btn" style="margin-left:5px;"> 
					<div class="blank"> 
						<a title="<?php echo JText::_('COM_CONTACTMAP_CHERCHER_ADRESSE_DESC'); ?>" href="javascript:;"  onclick="showAddress();"> 
						<?php echo JText::_('COM_CONTACTMAP_CHERCHER_ADRESSE'); ?></a> 
					</div> 
				</div> 
			</td>
		</tr>
		<tr>
			<td width="110" class="key">
				<label for="glat">
					<?php echo JText::_('COM_CONTACTMAP_LAT'); ?>
				</label>
				<label for="glng">
					- <?php echo JText::_('COM_CONTACTMAP_LNG'); ?>
				</label>
				<label for="gzoom">
					- <?php echo JText::_('COM_CONTACTMAP_ZOOM'); ?>
				</label>
			</td>
			<td valign="top">
				<input class="input-medium" onblur="IsReal('glat');" type="text" name="jform[lat]" id="glat" size="24" maxlength="30" value="<?php echo $this->item->lat; ?>" />
				<input class="input-medium" onblur="IsReal('glng');" type="text" name="jform[lng]" id="glng" size="24" maxlength="30" value="<?php echo $this->item->lng ?>" />
				<input class="input-medium" onblur="IsReal('gzoom');" type="text" name="jform[zoom]" id="gzoom" size="2" maxlength="12" value="<?php echo $this->item->zoom ?>" />
				<div class="btn" style="margin-left:5px;"> 
					<div class="blank"> 
						<a title="<?php echo JText::_('COM_CONTACTMAP_CHERCHER_COORDONNEES_DESC'); ?>" href="javascript:;"  onclick="getCoordinate();"> 
						<?php echo JText::_('COM_CONTACTMAP_CHERCHER_COORDONNEES'); ?></a> 
					</div> 
				</div> 
			</td>
		</tr>
		<tr>
			<td width="100" class="key">
				<label for="map">
					<?php echo JText::_('COM_CONTACTMAP_CARTE'); ?>:
				</label>
			</td>
			<td>
				<div id="map" style="width: 100%; height: 500px; overflow:hidden;"></div>
				<div id="info_geolocalisation" class="gmapfp_geolocal_info"></div>
			</td>
		</tr>
		<tr>
			<td width="100" class="key">
				<label for="marker"><?php echo JText::_( 'COM_CONTACTMAP_MARKER' ); ?>:</label>
			</td>
			<td>
				<div class="controls" style=" height: auto; ">
					<fieldset class="radio btn-group" style="white-space: normal;">
					<?php 
						$marqueurs = '';
						$marqueur_cat = '';
						
						//ajoute les lments du marqueur par dfaut
						$defaul_marqueur = new stdclass();
						$defaul_marqueur->url = JUri::root().'images/gmapfp/marqueurs/cat_default.png';
						$defaul_marqueur->name = JText::_( 'COM_CONTACTMAP_MARKER_CAT_DEFAULT');
						$defaul_marqueur->id = 0;
						array_unshift($this->marqueurs, $defaul_marqueur);
						
						$cnt = 0;
						foreach($this->marqueurs as $marqueur) {
							$checked = '';
							if ($this->item->marqueur_id == 0 or (!$this->item->marqueur_id and $cnt==0)) { $checked = 'checked="checked"'; }
							$checked = '';
							if ($this->item->marqueur_id == $marqueur->id) { $checked = 'checked="checked"'; }
							$marqueurs .= '<label for="marqueur_id'.$cnt.'" style="display: inline-block !important;height: 46px"><img src="'.$marqueur->url.'" title="'.$marqueur->name.'" /></label><input type="radio" style="float:none;" name="jform[marqueur_id]" id="marqueur_id'.$cnt.'" value="'.$marqueur->id.'" '.$checked.' />';
							$cnt++;
						}
						echo $marqueur_cat.$marqueurs;
					?>
					</tr>
				</div>
			</td>
		</tr>
	</table>
	<div>
		<input type="hidden" name="controller" value="map" />
		<input type="hidden" name="task" value="map.apply" />
		<input type="hidden" name="jform[contact_id]" value="<?php echo $this->item->contact_id; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
	<p><button onclick="submit('map.apply')" style="font-size: 1.4em;" class="btn btn-small btn-success">
		<span class="icon-apply icon-white"></span>
		<?php echo JText::_('COM_CONTACTMAP_SAVE_INFORMATION'); ?>
	</button></p>
</form>
	<div style="text-align: center;"><?php echo JText::_( 'COM_CONTACTMAP_COPYRIGHT' ); ?></div>
