<?php
	/*
	* GMapFP Plugin list for Page Builder CK
	* Version J3_2
	* Creation date: Juillet 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/
 
defined('_JEXEC') or die;
jimport('joomla.event.plugin');

class plgPagebuilderckGMapFP_liste extends JPlugin {

	private $context = 'PLG_PAGEBUILDERCK_GMAPFP_LISTE';

	private $type = 'gmapfp_liste';

	/* 
	 * Construct the Menu Item to drag into the interface
	 *
	 * Return Object with item data
	 */
	public function onPagebuilderckAddItemToMenu() {
		// load the language files of the plugin
		$this->loadLanguage();
		// create the menu item
		$menuitem = new stdClass();
		$menuitem->type = $this->type;
		$com_gmapfp_exist = file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/gmapfps.php');
		if ($com_gmapfp_exist) {
			$menuitem->title = JText::_($this->context . '_MENUITEM_TITLE');
			$menuitem->description = JText::_($this->context . '_MENUITEM_DESC');
			$menuitem->image = JUri::root(true) . '/plugins/pagebuilderck/gmapfp_liste/assets/images/gmapfp.png';
		} else {
			$menuitem->title = JText::_($this->context . '_MENUITEM_TITLE');
			$menuitem->description = JText::_($this->context . '_MENUITEM_DESC_ERROR');
			$menuitem->image = JUri::root(true) . '/plugins/pagebuilderck/gmapfp_liste/assets/images/gmapfp.png';
		}

		return $menuitem;
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemContentGMapFP_liste() {
		// ckstyle and inner classes are needed to get the styles from the interface
		$input = JFactory::getApplication()->input;
		$id = $input->get('ckid', '', 'string');
		
		?>
		<div id="<?php echo $id; ?>" class="cktype" data-type="<?php echo $this->type ?>">
			<div class="ckstyle">
			</div>
			<div class="gmapfpck inner">
				<ul>
					<li>
						<a href="#" class="gmapfp_list_item_link modal">
							<div class="gmapfp_list_item_img"> <img src="<?php echo JUri::root(true); ?>/plugins/pagebuilderck/gmapfp_liste/assets/images/gmapfp.png" style="height:60px; border-radius:30px;"> </div> 
							<h3 class="gmapfp_list_item_title">GMapFP Développement</h3> 
						</a>
					</li>
				</ul>
				<div class="gmapfpmarkertitleck"></div>
				<div class="gmapfpmarkercontentck"></div>
			</div>
		</div>
		<?php
	}

	/* 
	 * Display the html code for the item to be used into the interface
	 *
	 * Return String the html code
	 */
	public function onPagebuilderckLoadItemOptionsGMapFP_liste() {
		// load the language files of the plugin
		$this->loadLanguage();
		// load the interface for the options
		$tpl = JPATH_SITE . '/plugins/pagebuilderck/gmapfp_liste/layouts/edit_gmapfp_liste.php';
		return $tpl;
	}

	/* 
	 * Display the html code for the item to be used into the frontend page
	 * @param string the item object from simple_html_dom
	 * 
	 * Return String the html code
	 */
	public function onPagebuilderckRenderItemGMapFP_liste($item) {
		// load the helper to help us to use the parameters
		include_once JPATH_ADMINISTRATOR . '/components/com_pagebuilderck/helpers/pagebuilderckfront.php';

		// ckstyle and inner classes are needed to get the styles from the interface
		$ckstyle = $item->find('.ckstyle');
		$styles = count($ckstyle) ? $ckstyle[0]->innertext : '';

		$mapattrs = $item->find('.tab_list'); // this is the tab id in the interface which contains the map options
		$params = PagebuilderckFrontHelper::createParamsFromElement($mapattrs);

		$html 		= '';
		$catids		= $params->get('gmapfpcatid', '');
		$ids 		= $params->get('gmapfpplaceid', '');
		$lientype 	= $params->get('gmapfplink', '1');
		$balise 	= $params->get('gmapfph', '3');
		$image 		= $params->get('gmapfpimg', '1');
		$hauteur 	= $params->get('gmapfpheight', '60px');
		$radius 	= $params->get('gmapfpradius', '30px');

		$com_gmapfp_exist = file_exists(JPATH_SITE.'/components/com_gmapfp/models/gmapfp.php');
		if ($com_gmapfp_exist) {
			require_once JPATH_SITE.'/components/com_gmapfp/models/gmapfp.php';
			if (class_exists('GMapFPModelGMapFP'))
				$model = new GMapFPModelGMapFP();
			elseif (class_exists('GMapFPsModelGMapFP'))
				$model = new GMapFPsModelGMapFP();
			else
				$model = new GMapFPsModelGMapFPs();

			if ($ids) {
				$model->set_ids($ids);
				$lieux = $model->getGMapFPList();
			}
			
			if ($catids) {
				$model->set_catid($catids);
				if (!empty($lieux)) {
					$lieux2 = $model->getGMapFPList();
					$lieux = array_merge ($lieux2, $lieux);
				} else 
					$lieux = $model->getGMapFPList();
			}
		
			switch ($image) {
				case 1 :
					$gmapfp_path_img = "images/gmapfp/thumbsGMap/";
					break;
				case 2 :
					$gmapfp_path_img = "images/gmapfp/thumbsArt/";
					break;
				case 3 :
					$gmapfp_path_img = "images/gmapfp/";
					break;
				default :
					$gmapfp_path_img = "";
			}
			//Insertion des entêtes GMapFP si non déjà fait.
			$gmapfp_pro =  file_exists(JPATH_ADMINISTRATOR.'/components/com_gmapfp/models/champs.php');
			if ($gmapfp_pro) {
				require_once JPATH_SITE.'/components/com_gmapfp/helpers/define.php';
				Define_ModelGMapFP::define_gmapfp(0, array('CSS', 'LIGHTBOX'));
			} else {
				$model->define_gmapfp();
				$gmapfp_path_img = "images/gmapfp/";
			}
		
		}

		if ($lieux) {
			$app			= JFactory::getApplication(); 
			$gmapfp_params 	= $app->getParams('com_gmapfp');
			$target 		= $gmapfp_params->get('target');
			$gmapfp_largeur_lightbox = $gmapfp_params->get('gmapfp_largeur_lightbox', 1200);
			$gmapfp_hauteur_lightbox = $gmapfp_params->get('gmapfp_hauteur_lightbox', 800);

			if(!class_exists('GMapFPHelperRoute')) require_once (JPATH_SITE . '/components/com_gmapfp/helpers/route.php');

			$html .= '
				<div class="gmapfp_pagebuilderck_list">
					<ul>';
			foreach ($lieux as $lieu) {
					switch ($target)
					{
					case 1:
						// open in parent avec navigation
						$link = JRoute::_(GMapFPHelperRoute::getArticleRoute($lieu->slug, $lieu->catid), false);
						$read_more_link='<a href="'.$link.'"  target="_parent" class="gmapfp_list_item_link" >';
						break;
					case 2:
						// open in nouvelle fenêtre avec barre de navigation
						$link = JRoute::_(GMapFPHelperRoute::getArticleRoute($lieu->slug, $lieu->catid), false);
						$read_more_link='<a href="'.$link.'"  target="_blank" class="gmapfp_list_item_link" >';
						break;
					case 3:
						// open in a popup window
						$link = JRoute::_(GMapFPHelperRoute::getArticleRoute($lieu->slug, $lieu->catid), false);
						$read_more_link='<a href=# onclick="window.open(\''.$link.'\', \'\', \'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width='.$gmapfp_largeur_lightbox.',height='.$gmapfp_hauteur_lightbox.'\')" class="gmapfp_list_item_link" >';
						break;
					default:
						// open in lightbox
						if (substr($gmapfp_largeur_lightbox, -2) == 'px') $gmapfp_largeur_lightbox = substr($gmapfp_largeur_lightbox, 0, -2);
						if (substr($gmapfp_hauteur_lightbox, -2) == 'px') $gmapfp_hauteur_lightbox = substr($gmapfp_hauteur_lightbox, 0, -2);
						if (substr($gmapfp_largeur_lightbox, -1) == '%') {
							$gmapfp_largeur_lightbox = 'gmapfp_largeur_lightbox';
						}
						if (substr($gmapfp_hauteur_lightbox, -1) == '%') {
							$gmapfp_hauteur_lightbox = 'gmapfp_hauteur_lightbox';
						}
						$link = JRoute::_(GMapFPHelperRoute::getArticleRoute($lieu->slug, $lieu->catid).'&tmpl=component', false);
						$read_more_link='<a rel="{size: {x:'.$gmapfp_largeur_lightbox.', y:'.$gmapfp_hauteur_lightbox.'}, handler:\'iframe\'}" href="'.$link.'" class="gmapfp_list_item_link modal" >';
						break;
					}


				switch ($lientype) {
					case 3:
						$html .= '
								<li>
								';
						if ($gmapfp_path_img) $html .= '
									<div class="gmapfp_list_item_img">
										'.$read_more_link.'
											<img alt="'.$lieu->alias.'" src="'.$gmapfp_path_img.$lieu->img.'" style="height:'.$hauteur.'; border-radius:'.$radius.'">
										</a>
									</div>
								';
						$html .= '
									<h'.$balise.' class="gmapfp_list_item_title">'.$lieu->nom.'</h'.$balise.'>
								</li>
						';
						break;
					case 2:
						$html .= '
								<li>
								';
						if ($gmapfp_path_img) $html .= '
									<div class="gmapfp_list_item_img">
										<img alt="'.$lieu->alias.'" src="'.$gmapfp_path_img.$lieu->img.'" style="height:'.$hauteur.'; border-radius:'.$radius.'">
									</div>
								';
						$html .= '
									'.$read_more_link.'
										<h'.$balise.' class="gmapfp_list_item_title">'.$lieu->nom.'</h'.$balise.'>
									</a>
								</li>
						';
						break;
					case 1:
						$html .= '
								<li>
									'.$read_more_link.'
								';
						if ($gmapfp_path_img) $html .= '
										<div class="gmapfp_list_item_img">
											<img alt="'.$lieu->alias.'" src="'.$gmapfp_path_img.$lieu->img.'" style="height:'.$hauteur.'; border-radius:'.$radius.'">
										</div>
								';
						$html .= '
										<h'.$balise.' class="gmapfp_list_item_title">'.$lieu->nom.'</h'.$balise.'>
									</a>
								</li>
						';
						break;
					default:
						$html .= '
								<li>
								';
						if ($gmapfp_path_img) $html .= '
									<div class="gmapfp_list_item_img">
										<img alt="'.$lieu->alias.'" src="'.$gmapfp_path_img.$lieu->img.'" style="height:'.$hauteur.'; border-radius:'.$radius.'">
									</div>
								';
						$html .= '
									<h'.$balise.' class="gmapfp_list_item_title">'.$lieu->nom.'</h'.$balise.'>
								</li>
						';
						break;
				}
			}
			$html .= '</ul>
				</div>';
				
			$html = '
			<div class="ckstyle">
				'. $styles . '
			</div>
			<div class="gmapfpck inner">
				'.$html.'
			</div>';
		}

		return $html;
	}
}