<?php
	/*
	* GMapFP Component MtoFP for Joomla! 3
	* Version J3_3
	* Creation date: Janvier 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

class Yahoo_WeatherAPI {
	/** City code input **/
	private $city_code = '';
	
	/** City label get on the webservice **/
	private $city = '';
	
	/** Unit system get on the webservice **/
	private $unit_system = '';
	
	/** Domain of the website **/
	private $domain = 'http://query.yahooapis.com/v1/public/yql';
	
	/** Prefix of the img link **/
	private $prefix_images = '';
	
	/** Array with current weather **/
	private $current_conditions = array();
	
	/** Array with forecast weather **/
	private $forecast_conditions = array();
	
	/** If the city was found **/
	private $is_found = true;

	/** The HTML response send by the service **/
	private $response;
	
	/**
	* Class constructor
	* @param $city_code is the label of the city
	* @param $lang the lang of the return weather labels
	* @return ...
	*/
	 
	function __construct ($city, $unit='c', $cache=1, $cache_time=15) {
		
		$this->city_code = $city;
		$getContentCode = "";
		
		$yql_query = 'select * from weather.forecast where woeid = '.$city.' and u=\''.$unit.'\'';
		$this->url = $this->domain . "?q=" . urlencode($yql_query) . "&format=xml";
		
		// die(print_r($this->url));
		clearstatcache();
		if($cache == 0) {
			//rcupre les donnes sur le serveur Yahoo
			if (extension_loaded('curl')) {
				$getContentCode = $this->getCurlContent($this->url);
				if(($getContentCode != 200) and ($getContentCode != 302)) { //302 demande de captcha par google. 200 responce bonne
					$getContentCode = $this->getHttpContent($this->url, $getContentCode);
				}
			}
		} else {
			if(!file_exists(JPATH_CACHE.'/mod_meteofp_yahoo.xml') || (filesize(JPATH_CACHE.'/mod_meteofp_yahoo.xml') < 2048) || ((filemtime(JPATH_CACHE.'/mod_meteofp_yahoo.xml') + $cache_time * 60) < time())) {
				//rcupre les donnes sur le serveur Yahoo
				if (extension_loaded('curl')) {
					$getContentCode = $this->getCurlContent($this->url);
					if(($getContentCode != 200) and ($getContentCode != 302)) { //302 demande de captcha par google. 200 responce bonne
						$getContentCode = $this->getHttpContent($this->url, $getContentCode);
					}
				} else {
						$getContentCode = $this->getHttpContent($this->url, $getContentCode);
				}
				//si data rcupr, les sauvegarder dans le cache
				if($getContentCode == 200) {
					JFile::write(JPATH_CACHE.'/mod_meteofp_yahoo.xml', $this->response);
				}
			} else {
				$this->response = JFile::read(JPATH_CACHE.'/mod_meteofp_yahoo.xml');
				$getContentCode = 200;
			}
		}


		if($getContentCode == 200) {
		
			$content = utf8_encode($this->response);
                        $content = str_replace('yweather:','yweather_', $content);
                        $content = str_replace('geo:','geo_', $content);
			// die(print_r($content));			
			
			$xml = simplexml_load_string($content);
			
			$this->is_found = false;
			if(!isset($xml->weather->problem_cause)) {
				
				$xml = simplexml_load_string($content);
					// die(print_r($xml));

				if ($xml and property_exists($xml, 'results') and property_exists($xml->results, 'channel') and property_exists($xml->results->channel, 'yweather_location')) {
					$this->city = (string)$xml->results->channel->yweather_location->attributes()->city;
					
					//units
					$this->current_conditions['unit_temp'] = (string)$xml->results->channel->yweather_units->attributes()->temperature;
					$this->current_conditions['unit_dest'] = (string)$xml->results->channel->yweather_units->attributes()->distance;
					$this->current_conditions['unit_pres'] = (string)$xml->results->channel->yweather_units->attributes()->pressure;
					$this->current_conditions['unit_vit'] = (string)$xml->results->channel->yweather_units->attributes()->speed;

					//condition
					$this->current_conditions['condition'] = (string)$xml->results->channel->item->yweather_condition->attributes()->text;
					$this->current_conditions['temp'] = (string)$xml->results->channel->item->yweather_condition->attributes()->temp;
					$this->current_conditions['icon'] = (string)$xml->results->channel->item->yweather_condition->attributes()->code;
					$this->current_conditions['date'] = (string)$xml->results->channel->item->yweather_condition->attributes()->date;

					//atmosphere
					$this->current_conditions['humidity'] = (string)$xml->results->channel->yweather_atmosphere->attributes()->humidity;
					$this->current_conditions['visibility'] = (string)$xml->results->channel->yweather_atmosphere->attributes()->visibility;
					$this->current_conditions['pressure'] = (string)$xml->results->channel->yweather_atmosphere->attributes()->pressure;
					$this->current_conditions['rising'] = (string)$xml->results->channel->yweather_atmosphere->attributes()->rising;

					//vent
					$this->current_conditions['chill'] = (string)$xml->results->channel->yweather_wind->attributes()->chill;
					$this->current_conditions['direction'] = (string)$xml->results->channel->yweather_wind->attributes()->direction;
					$this->current_conditions['speed'] = (string)$xml->results->channel->yweather_wind->attributes()->speed;

					//soleil
					$this->current_conditions['leve'] = (string)$xml->results->channel->yweather_astronomy->attributes()->sunrise;
					$this->current_conditions['couche'] = (string)$xml->results->channel->yweather_astronomy->attributes()->sunset;

					foreach($xml->results->channel->item->yweather_forecast as $this->yweather_forecast_value) {
						$this->forecast_conditions_temp = array();
						$this->forecast_conditions_temp['day_of_week'] = (string)$this->yweather_forecast_value->attributes()->day;
						$this->forecast_conditions_temp['date'] = (string)$this->yweather_forecast_value->attributes()->date;
						$this->forecast_conditions_temp['low'] = (string)$this->yweather_forecast_value->attributes()->low;
						$this->forecast_conditions_temp['high'] = (string)$this->yweather_forecast_value->attributes()->high;
						$this->forecast_conditions_temp['icon'] = (string)$this->yweather_forecast_value->attributes()->code;
						$this->forecast_conditions_temp['condition'] = (string)$this->yweather_forecast_value->attributes()->text;
						$this->forecast_conditions []= $this->forecast_conditions_temp;
					}
					$this->is_found = true;
				}
			}
		} else {
			if ($getContentCode) trigger_error('Yahoo results parse problem _ http error '.$getContentCode);
			return null;
		}
	}
	
    private function prepareTime($time) {
        $f_date = date("Y-m-d")." ".$time;
        $pos = strpos($f_date, "pm");
        $f_date = preg_replace('/ [a-z][a-z]/', ':00', $f_date);
        return strtotime($f_date) + (($pos !== FALSE) ? 12*3600 : 0);
    }

	public function getCurlContent($url)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_URL, $url);
        $this->response = curl_exec($curl);
		$infos = curl_getinfo($curl);
        curl_close ($curl);
        return $infos['http_code'];
    }
	
	public function getHttpContent($url, $infos)
    {
		if ($this->response = @file_get_contents($url)) {
        	return 200;
		}
		return '2000'.' '.$infos;
    }
	/**
	 * Get the city
	 */
	 
	function getCity() {
		return $this->city;
	}
	
	/**
	 * Get the unit_system
	 */
	 
	function getUnit_system() {
		return $this->current_conditions['unit_temp'];
	}
	
	/**
	 * Get the current weather
	 */
	 
	function getCurrent() {
		return $this->current_conditions;
	}
	
	/**
	 * Get the forecast weather
	 */
	 
	function getForecast() {
		return $this->forecast_conditions;
	}
	
	/**
	 * If teh city was found
	 */
	 
	function isFound() {
		return $this->is_found;
	}
	
}
?>