<?php 
	/*
	* GMapFP Component Yahoo Mto for Joomla! 3.x
	* Version J3_2
	* Creation date: Janvier 2017
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: webmaster@gmapfp.org
	* License GNU/GPL
	*/

defined('_JEXEC') or die('Restricted access'); 

require_once (JPATH_SITE.'/modules/mod_meteofp/helper_Yahoo.php');

// dtecte langue
jimport( 'joomla.language.helper' );
$lang = JLanguageHelper::detectLanguage();
$lang = substr($lang,0,2);
if (!@$this->params->woeid) $this->params->woeid = 12725169;
// create output string
$output = "<div class='item-page'>";
$output .= "<div class='mod_meteofp".$this->params->moduleclass_sfx."'>\n";

if ($this->params->temp_unit == 'f') { $temp_unit = 'f'; } else { $temp_unit = 'c'; };
$meteo = new Yahoo_WeatherAPI($this->params->woeid, $temp_unit, $this->params->cache, $this->params->cache_time);
	
if ($meteo->isfound()) {
	//definition des variable et infos
	
	if ($this->params->icon_yahoo  == "") $this->params->icon = "natif";
	$icon_path = JURI::base()."modules/mod_meteofp/icons/yahoo/".$this->params->icon_yahoo."/";
	$actuelle = $meteo->getCurrent();
		//die(print_r($actuelle));

	// add automatic margin to image to beauty outputs without stylesheets
	$img_margin = "5px 0";
	if ($this->params->img_align=="left") { $img_margin = "0 20px 5px 0";  }
	if ($this->params->img_align=="right") { $img_margin = "0 0 5px 20px";  }

	$output .=  "<div class='meteofp_city'><h2>".$meteo->getCity()."</h2></div>";

 	if ($actuelle) {
		switch ($this->params->temp_unit) {
			case 'c':
				$tmp_actuelle = $actuelle['temp']."&nbsp;&deg;C";
			break;
			case 'f':
				$tmp_actuelle = $actuelle['temp']."&nbsp;&deg;F";
			break;
			default:
				if ($meteo->getUnit_system() == 'C') {
					$tmp_actuelle = "(&nbsp;".round(($actuelle['temp']*9/5)+32)."&nbsp;&deg;F&nbsp;/&nbsp;";
					$tmp_actuelle .= $actuelle['temp']."&nbsp;&deg;C&nbsp;)";
				} else {
					$tmp_actuelle = "(&nbsp;".$actuelle['temp']."&nbsp;&deg;F&nbsp;/&nbsp;";
					$tmp_actuelle .= round(($actuelle['temp']-32)*5/9)."&nbsp;&deg;C&nbsp;)";
				}
		}

		//actuelle
		$output .= "<div class='meteofp_global'>\n";
		$output .= "<div class='meteofp_actuelle'>\n";
		$output .=  "<div class='meteofp_date'><p><h3>".JHtml::date('now', JText::_($this->params->afficher_date))."</h3></p></div>";
		if ($this->params->icon_yahoo != -1) {
			$icon = basename($actuelle['icon']);
			if ($this->params->icon_yahoo == "natif") {
			if ($actuelle['icon'] == 3200) {
				$path_icon = "http://l.yimg.com/a/i/us/nws/weather/gr/44d.png";
			} else {
				$path_icon = "http://s.imwx.com/v.20100719.135915/img/wxicon/52/".$actuelle['icon'].".png";
			}
			} else {
				if (empty($icon)) {
					$icon = "warning.png";
				} else {
					$icon = $icon.".png";
				}
				$path_icon = JURI::base().'modules/mod_meteofp/icons/yahoo/'.$this->params->icon_yahoo.'/'.$icon;
			}
			$output .= "<img class='meteofp_img' src='".$path_icon."' alt='".JText::_("METEOFP_".str_replace(' ', '_', $actuelle['condition']))."'  title='".JText::_("METEOFP_".str_replace(' ', '_', $actuelle['condition']))."' align='".$this->params->img_align."' style='margin:".$img_margin.";' />";
		}
		$output .= "<label>".(JText::_(($actuelle['condition']!="") ? "METEOFP_".str_replace(' ', '_', $actuelle['condition']) : "---" ))."</label> ";
		$output .= $tmp_actuelle;
		$output .= "<br />".JText::sprintf('METEOFP_PRESSION', $actuelle['pressure'], $actuelle['unit_pres']);
		$output .= "<br />".JText::sprintf('METEOFP_HUMIDITE', $actuelle['humidity']);
		$output .= "<br />".JText::sprintf('METEOFP_VISIBILITE', $actuelle['visibility'], $actuelle['unit_dest']);
		if ($actuelle['speed']) {
			$output .= "<br />".JText::sprintf('METEOFP_VENT', $actuelle['speed'], $actuelle['unit_vit']);
		} else {
			$output .= "<br />".JText::_('METEOFP_CALME');
		}
		//si direction = 0 => direction variable.
		if ($actuelle['direction']) $output .= '&nbsp;'.JText::_( 'METEOFO_DIRECTION_'.(ceil(($actuelle['direction']-5.62)/11.25)+1) );
		
		$time12_24_leve = substr($actuelle['leve'], -2);
		$heures_leve = (int)substr($actuelle['leve'], 0 ,2);
		$minutes_leve = substr($actuelle['leve'], -5 ,2);
		if ($this->params->t12_24 == "24") {
			if ($time12_24_leve == "pm") {
				$heures_leve = $heures_leve + 12;
			}
			$time12_24_leve = "";
		}
		$time12_24_couche = substr($actuelle['couche'], -2);
		$heures_couche = (int)substr($actuelle['couche'], 0 ,2);
		$minutes_couche = substr($actuelle['couche'], -5 ,2);
		if ($this->params->t12_24 == "24") {
			if ($time12_24_couche == "pm") {
				$heures_couche = $heures_couche + 12;
			}
			$time12_24_couche = "";
		}
		$output .= "<br />".JText::sprintf('METEOFP_LEVE', $heures_leve, $minutes_leve, $time12_24_leve);
		$output .= "<br />".JText::sprintf('METEOFP_COUCHE',$heures_couche , $minutes_couche, $time12_24_couche);
		$output .= "</div>\n";
		
		// output forecast
		$previsions = $meteo->getForecast();
		$unit_system = $meteo->getUnit_system();
		
		$output .= "<div class='meteofp_previsions'>";
		$output .= "<label><h3>".JText::_('MOD_METEOFP_PREVISIONS')."</h3></label>";
		$i = 0;
		foreach ($previsions as $prevision) {
			$low = $prevision['low']; $high = $prevision['high'];
			// recalcul la temperature si necessaire
			if ($unit_system=="C") {
				$lowF = round((($low*9)/5)+32); $highF = round((($high*9)/5)+32);
				$lowC = $prevision['low']; $highC = $prevision['high'];
			} else {
				$lowC = round((($low-32)*5)/9); $highC = round((($high-32)*5)/9);
				$lowF = $prevision['low']; $highF = $prevision['high'];
			}
		
			$icon = basename($prevision['icon']);
			if ($this->params->icon_yahoo_previsions == "natif") {
				$path_icon = "http://s.imwx.com/v.20100719.135915/img/wxicon/52/".$prevision['icon'].".png";
			} else {
				if (empty($icon)) {
					$icon = "warning.png";
				} else {
					$icon = $icon.".png";
				}
				$path_icon = JURI::base().'modules/mod_meteofp/icons/yahoo/'.$this->params->icon_yahoo_previsions.'/'.$icon;
			}
			$output .= "<div class='meteofp_previsions_item' style='width:145px;vertical-align: top;'>";
			if ($i) {
				$output .= "<p><label>".JText::_($prevision['day_of_week'])."</label></p>";
			} else {
				$output .= "<p><label>".JText::_('METEOFP_TODAY')."</label></p>";
			}
			$previsions = array ();
			$prevs = explode('/', $prevision['condition']);
			foreach ($prevs as $prev) {
				$moment = "";
				//test si AM au dbut des condition mto
				if (!substr_compare(strtoupper($prev), "PM ", 0, 3)) {
					$prev = substr($prev, 3);
					$moment = JText::_("METEOFP_PM");
				}
				//test si PM au dbut des condition mto
				if (!substr_compare(strtoupper($prev), "AM ", 0, 3)) {
					$prev = substr($prev, 3);
					$moment = JText::_("METEOFP_AM");
				}
				//test si EARLY au dbut des condition mto
				if (!substr_compare(strtoupper($prev), " EARLY", -6)) {
					$prev = substr($prev, 0, -6);
					$moment = JText::_("METEOFP_EARLY");
				}
				//test si LATE au dbut des condition mto
				if (!substr_compare(strtoupper($prev), " LATE", -5)) {
					$prev = substr($prev, 0, -5);
					$moment = JText::_("METEOFP_LATE");
				}
				$previsions[] = JText::_("METEOFP_".str_replace(' ', '_', $prev)).$moment;
			}
			$prev = implode(JText::_("METEOFP_SEPARATOR"), $previsions);
			
			$output .= '<img src="'.$path_icon.'" align="'.$this->params->img_align.'" style="margin:'.$img_margin.';" alt="'.$prev.'" title="'.$prev.'"/>'
					.'<p style="float: '.$this->params->img_align.'; clear: both;" >'.$prev.'<br />';
			if ($this->params->temp_unit != 'f') $output .= $lowC."&nbsp;&rArr;&nbsp;".$highC."&nbsp;<sup>o</sup>C".'<br />';
			if ($this->params->temp_unit != 'c') $output .= $lowF."&nbsp;&rArr;&nbsp;".$highF."&nbsp;<sup>o</sup>F";
			$output .= '</p></div>';
			$i++;
		}
		$output .= "</div>";

	} else {
		if ($this->params->icon != -1) {
			$output .= "<img class='meteofp_img' src='".$icon_path."warning.png' alt='error' align='".$this->params->img_align."' style='margin:".$img_margin.";' />";
		}
		$output .= "<p>".JText::_("MOD_METEOFP_NOT_INFO").$this->params->lieu."</p>\n";
	}

	} else {
		$output .=JText::_("MOD_METEOFP_VILLE_NON_TROUVEE");
	}
$output .= "</div></div></div>\n";

echo $output;
?>
