<?php

	/*
	* Plugin QuickIcon pour composant GMapFP pour Joomla! 4.x
	* Version J4_1_0
	* Creation date: Novembre 2023
	* Author: Fabrice4821 - www.gmapfp.org
	* Author email: support@gmapfp.org
	* License GNU/GPL
	*/

namespace Joomla\Plugin\Quickicon\GmapFp\Extension;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Event\SubscriberInterface;
use Joomla\Module\Quickicon\Administrator\Event\QuickIconsEvent;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

final class GmapFp extends CMSPlugin implements SubscriberInterface
{
    use DatabaseAwareTrait;

    protected $autoloadLanguage = true;

    public static function getSubscribedEvents(): array
    {
        return [
            'onGetIcons' => 'onGetIcons',
        ];
    }

    /**
     * Returns an icon definition for an icon which looks for overrides update
     * via AJAX and displays a notification when such overrides are updated.
     */
    public function onGetIcons(QuickIconsEvent $event): void
    {
        $context = $event->getContext();

        if (
            $context !== $this->params->get('context', 'site_quickicon')
            || !$this->getApplication()->getIdentity()->authorise('core.manage', 'com_gmapfp')
        ) {
            return;
        }

        $this->getApplication()->getDocument()->getWebAssetManager()
            ->registerAndUseScript('plg_quickicon_gmapfp', 'plg_quickicon_gmapfp/itemscheck.js', [], ['defer' => true], ['core']);

        // Add the icon to the result array
        $result = $event->getArgument('result', []);

        $tmp = [
                'link'  => 'index.php?option=com_gmapfp',
				'linkadd'  => 'index.php?option=com_gmapfp&view=item&layout=edit',
                'image' => 'fas fa-map-marked-alt',
                'icon'  => '',
                'name'  => $this->getApplication()->getLanguage()->_('PLG_QUICKICON_GMAPFP_OK'),
                'id'    => 'plg_quickicon_gmapfp',
                'group' => 'MOD_QUICKICON_MAINTENANCE',
            ];

		if ((int) $this->params->get('show_items',1)) {
			$tmp['ajaxurl'] = 'index.php?option=com_gmapfp&amp;task=items.getQuickiconGmapfp&amp;format=json';
		}
		
		$result[] = [$tmp];
		
        $event->setArgument('result', $result);
    }
}
